setwd("<your directory or folder path>")

n <- 50 #assume same sample size per group
#SSQ <- 209.19*n/57
alpha<- 0.05 
sigma <- 1.5
SE <- sqrt(2)*sigma / sqrt(n)
#SE <- sigma / sqrt(SSQ)
#
# 
# delta is the true parameter value:
delta <- c(-1.0*sigma, -0.85*sigma, -0.75*sigma, -0.65*sigma, -0.5*sigma, -0.45*sigma, -0.33*sigma, -0.25*sigma, -0.14*sigma, -0.10*sigma, -0.025*sigma, -0.005*sigma, 0.0, 0.005*sigma, 0.025*sigma, 0.1*sigma, 0.14*sigma, 0.15*sigma, 0.25*sigma, 0.33*sigma, 0.45*sigma, 0.5*sigma, 0.65*sigma, 0.75*sigma, 0.85*sigma, 1.0*sigma)
delsig <- seq(from=-3.0,to=+3.0,by=0.01)#if sigma cannot be estimated, this is effect in sigma units
# note that in general delta coul;d be negative (mu1 < mu2), 0 (mu1 = mu2), or positive (mu1 > mu2)
dfe <- n - 2
# Tcrit is the two-sided (+/-) critical value for the t-test statistic:
Tcrit <- qt(p=1-alpha/2,df=dfe,ncp=0.0) #this is the 100(1-alpha/2) percentile of the t distribution with 2n-2 d.f.
#
# ncp is called the non-centrality parameter; when the null hypothesis of zero difference is true, then ncp = 0.0
# as the truth departs from the null (i.e., as delta differs from 0), the ncp changes
#
#ncp.alt <- delta/SE
ncp.alt <- delsig*sqrt(n)/sqrt(2)
# power is the probability of rejecting the null hypothesis: H0: mu1 - mu2 = 0, given 
# that the true difference is delta.
# Note that if delta = 0, the power is equal to alpha
power <- pt(q=Tcrit,df=dfe,ncp=ncp.alt,lower.tail=FALSE)+pt(q=-Tcrit,df=dfe,ncp=ncp.alt,lower.tail=TRUE)


plot(delsig,power,ylim=c(0,1))
abline(h=0.95)
abline(h=alpha)
abline(v=-0.735)
abline(v=+0.735)
text(x=-2,y=0.60,labels="delsig=-0.735")
text(x=1.75,y=0.60,labels="delsig=+0.735")
df3 <- cbind(n,alpha,delsig, power)

write.csv(df3,"20191124 Power for T test.csv")